<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medicine_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertMedicine($data) {
        $this->db->insert('medicine', $data);
    }

    function loadMedicine($data) {
        $this->db->insert('medicine_load_list', $data);
    }

    function getMedicine() {
        //$this->db->order_by('name', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineForms() {
        $this->db->select('form');
        $this->db->order_by('form', 'asc');
        $this->db->group_by('form');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine.generic,medicine.packsize');    
        $this->db->from('medicine'); 
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $query = $this->db->get();
        return $query->result();
    }

    function getLatestMedicine() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineLimitByNumber($number) {
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', $number);
        return $query->result();
    }

    function getMedicineByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByStockAlert() {
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineByStockAlertByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineById($id) {
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine_generic.generic_name,medicine.generic');
        $this->db->from('medicine'); 
        $this->db->where('medicine.id',$id);
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $this->db->join('medicine_generic', 'medicine.generic=medicine_generic.generic_id','LEFT'); 
        $query = $this->db->get(); 
        return $query->row();
    }

    function getMedicineByIdforLoad($id) {
        $this->db->select('name,form,strength');
        $this->db->where('id',$id);
        $this->db->from('medicine');  
        $query = $this->db->get(); 
        return $query->row();
    }

    function getMedicineByKeyByStockAlert($page_number, $key) {
        $data_range_1 = 50 * $page_number;

        $this->db->where('quantity <=', 20);
        $this->db->or_like('name', $key);
        $this->db->or_like('company', $key);



        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByKey($page_number, $key) {
        $data_range_1 = 50 * $page_number;
        $this->db->like('name', $key);
        $this->db->or_like('company', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByKeyForPos($key) {
        $this->db->like('name', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function updateMedicine($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medicine', $data);
    }

    function insertMedicineCategory($data) {

        $this->db->insert('medicine_category', $data);
    }

    function getMedicineGeneric() {
        $this->db->order_by('generic_name', 'asc');
        $query = $this->db->get('medicine_generic');
        return $query->result();
    }

    function getMedicineCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medicine_category');
        return $query->row();
    }
    
    function getMedicineCompany() {
        $this->db->order_by('company_name', 'asc');
        $query = $this->db->get('medicine_company');
        return $query->result();
    }

    function totalStockPrice() {
        $query = $this->db->get('medicine')->result();
        $stock_price = array();
        foreach ($query as $medicine) {
            $stock_price[] = $medicine->price * $medicine->quantity;
        }

        if (!empty($stock_price)) {
            return array_sum($stock_price);
        } else {
            return 0;
        }
    }

    function updateMedicineCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medicine_category', $data);
    }

    function deleteMedicine($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine');
    }

    function deleteLoadMedicine($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine_load_list');
    }

    function deleteMedicineCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine_category');
    }

    function getMedicineBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine.generic,medicine.packsize');
        $this->db->like('medicine.id', $search);
        $this->db->or_like('medicine.name', $search); 
        $this->db->or_like('medicine_company.company_name', $search,'after');        
        $this->db->from('medicine'); 
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $query = $this->db->get();
        return $query->result();
        }
    }

    function getMedicineByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine.generic,medicine.packsize');
        $this->db->from('medicine'); 
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
    }

    function getMedicineByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine.generic,medicine.packsize');
        $this->db->like('medicine.id', $search,'after');
        $this->db->or_like('medicine.name', $search, 'after');    
        $this->db->or_like('medicine_company.company_name', $search,'after');    
        $this->db->from('medicine'); 
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
        }
    }

    function getMedicineNameByAvailablity($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
            $this->db->limit(10);
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        }

        return $query;
    }

    function getMedicineInfo($searchTerm) {
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->order_by('medicine.name', 'asc');
            $this->db->select('medicine.id,medicine.name,medicine.strength,medicine.form,medicine_company.company_name');
            $this->db->from('medicine'); 
            $this->db->where("name like '" . $searchTerm . "%' ");
            $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
            $fetched_records = $this->db->get();
            $medicines = $fetched_records->result_array();
            }
        } else {
            $this->db->order_by('medicine.name', 'asc');
            $this->db->select('medicine.id,medicine.name,medicine.strength,medicine.form,medicine_company.company_name');
            $this->db->from('medicine'); 
            $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
            $this->db->limit(5);
            $fetched_records = $this->db->get();            
            $medicines = $fetched_records->result_array();
        }
        // Initialize Array with fetched data
        $data = array();
        foreach ($medicines as $medicine) {
            $data[] = array("id" => $medicine['id']."*".$medicine['name'].' ('.$medicine['strength'].')', "text" => $medicine['name'].' ('.$medicine['strength'].'), '.$medicine['form'].'; '.$medicine['company_name']);
        }
        return $data;
    }

    function getMedicineInfoForPharmacySale($searchTerm,$prescription) {
        if (!empty($prescription)) { 
            $this->db->where('id',$prescription);
            $this->db->where('TRIM(medicine)>','');
            $query = $this->db->get('prescription')->row(); 
            $medicineList = $query->medicine;
            $medicineList = explode('###', $medicineList);
            $medicineArr = array();
            foreach ($medicineList as $key => $value) {
               $single_medicine = explode('***', $value); 
               $medicineArr[]=$single_medicine[0];                                            
            }
               $this->db->select('medicine.id,medicine.s_price,medicine.name,medicine.quantity,medicine.strength,medicine.form,medicine_company.company_name');
               $this->db->from('medicine'); 
               $this->db->where('medicine.id',$medicineArr[0]);
               if (count($medicineArr)>1)
               {
                foreach ($medicineArr as $key => $value) {
                    $this->db->or_where('medicine.id',$value);                                           
                 }
               }
               $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
               $fetched_records = $this->db->get();
               $medicines = $fetched_records->result_array();
        }
        else if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->order_by('medicine.name', 'asc');
            $this->db->select('medicine.id,medicine.s_price,medicine.name,medicine.quantity,medicine.strength,medicine.form,medicine_company.company_name');
            $this->db->from('medicine'); 
            $this->db->where('quantity >', lang('medicine_min_stock_quantity'));
            $this->db->where("name like '" . $searchTerm . "%' ");
            $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
            $fetched_records = $this->db->get();
            $medicines = $fetched_records->result_array();
            }
        } else {
            $this->db->order_by('medicine.name', 'asc');
            $this->db->select('medicine.id,medicine.s_price,medicine.name,medicine.quantity,medicine.strength,medicine.form,medicine_company.company_name');
            $this->db->from('medicine'); 
            $this->db->where('quantity >', lang('medicine_min_stock_quantity'));
            $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
            $this->db->limit(5);
            $fetched_records = $this->db->get();            
            $medicines = $fetched_records->result_array();
        }
        // Initialize Array with fetched data
        $data = array();
        foreach ($medicines as $medicine) {
            $this->db->select('id');
            $this->db->where('medicine_id', $medicine['id']);
            $this->db->where('status', lang('Available'));
            $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
            $totExpire = $this->db->get('medicine_load_list')->num_rows();

            $data[] = array("id" => $medicine['id'] . '*' . (float) $medicine['s_price'] . '*' . $medicine['name'].' ('.$medicine['strength'].'), '.$medicine['form'] . '*' . $medicine['company_name'] . '*' . $medicine['quantity'] . '*' . $medicine['e_date']. '*' . $totExpire, "text" => $medicine['name'].' ('.$medicine['strength'].'), '.$medicine['form']);
        }
        return $data;
    }

    function getMedicineExpireAlertBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
        $this->db->where('status', lang('medicine_batch_status_available'));
        $this->db->group_start();
       // $this->db->like('id', $search);
       $this->db->like('name', $search,'after');
       $this->db->or_like('status', $search,'after');
       $this->db->or_like('entry_type', $search,'after');
       $this->db->or_like('batch_no', $search);
       $this->db->or_like('medicine_id', $search,'after');
        $this->db->group_end();
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineExpireAlertByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
        $this->db->where('status', lang('medicine_batch_status_available'));
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    function getMedicineExpireAlertByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
        $this->db->where('status', lang('medicine_batch_status_available'));
        $this->db->group_start();
        //$this->db->like('id', $search);
        $this->db->like('name', $search,'after');
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('entry_type', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('medicine_id', $search,'after');
        $this->db->group_end();
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    function getMedicineExpireAlert() {   
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
        $this->db->where('status', lang('medicine_batch_status_available'));
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    function getMedicineExpireAlertWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $this->db->where('e_date <', time() + (lang('month_calculation')*lang('medicine_expire_period')));
        $this->db->where('status', lang('medicine_batch_status_available'));
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }


    function getMedicineByGeneric($generic) {        
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,medicine_company.company_name,medicine.quantity,medicine.packsize');
        $this->db->from('medicine'); 
        $this->db->where('medicine.generic', $generic);
        $this->db->join('medicine_company', 'medicine.company=medicine_company.id','LEFT'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function getGenericName($generic) {
        $this->db->where('generic_id', $generic);
        $query = $this->db->get('medicine_generic');
        return $query->result_array();
    }

    function getLoadMedicineWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    function getLoadMedicineBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search);
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('entry_type', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('medicine_id', $search,'after');
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    
    function getLoadMedicineByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    
    function getLoadMedicineByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search);
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('status', $search,'after');
        $this->db->or_like('entry_type', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('medicine_id', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_load_list');
        return $query->result();
    }

    function getLoadMedicineById($id) {
        $this->db->select('name,batch_no,status');
        $this->db->where('id',$id);
        $this->db->from('medicine_load_list');  
        $query = $this->db->get(); 
        return $query->row();
    }

    function updateLoadMedicine($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medicine_load_list', $data);
    }

    function getMedicineListGroupBy() {
        $this->db->select('medicine.id,medicine.price, medicine.s_price,medicine.name,medicine.strength,medicine.form,sum(medicine_load_list.quantity) AS quantity');
        $this->db->from('medicine'); 
        $this->db->join('medicine_load_list', 'medicine.id=medicine_load_list.medicine_id','LEFT'); 
        $this->db->group_by('medicine.id'); 
        $query = $this->db->get(); 
        return $query->result();
    }

    function insertReturnCompany($data) {
        $this->db->insert('medicine_return_company', $data);
    }

    function deleteReturnCompany($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine_return_company');
    }

    function getReturnCompanyMedicineWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'asc');
        }
        $query = $this->db->get('medicine_return_company');
        return $query->result();
    }

    function getReturnCompanyMedicineBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('company', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('medicine_id', $search,'after');
        $query = $this->db->get('medicine_return_company');
        return $query->result();
    }

    
    function getReturnCompanyMedicineByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_return_company');
        return $query->result();
    }

    
    function getReturnCompanyMedicineByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search,'after');
        $this->db->or_like('company', $search,'after');
        $this->db->or_like('batch_no', $search);
        $this->db->or_like('medicine_id', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_return_company');
        return $query->result();
    }

    function getMedicineCompanies() {
        $this->db->order_by('company_name', 'asc');
        $this->db->select('company_name');
        $query = $this->db->get('medicine_company');
        return $query->result();
    }
}
