<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Home extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('finance/finance_model');
        $this->load->model('staff/staff_model');
        $this->load->model('appointment/appointment_model');
        $this->load->model('home_model');
        $this->load->library('encryption');
    }

    public function index() {
        
        if (time()>$this->encryption->decrypt($this->settings_model->getSettings()->live_appointment_type))
        redirect('home/license');

        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
     
        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('appointment/todaysDoctor');
        } else {
            $data['appointments'] = $this->appointment_model->getAppointment();
        }

        if ($this->ion_auth->in_group(array('Receptionist','Accountant'))) {
            redirect('finance/addPaymentView');
        }
        
		if ($this->ion_auth->in_group(array('Laboratorist'))) {
            redirect('lab/addLabView');
        }

        if ($this->ion_auth->in_group(array('Pharmacist'))) {
            redirect('finance/pharmacy/addPaymentView');
        }

        $data['this_month']['payment'] = $this->finance_model->thisMonthPayment();
        $data['this_month']['deposit'] = $this->finance_model->thisMonthDeposit();
        $data['this_month']['expense'] = $this->finance_model->thisMonthExpense();
        $data['this_month']['staffSalary'] = $this->staff_model->thisMonthStaffSalary();

        $data['this_day']['payment'] = $this->finance_model->thisDayPayment()[0]->total;
        $data['this_day']['payment_number'] = $this->finance_model->thisDayPayment()[0]->pay_number;
        $data['this_day']['expense'] = $this->finance_model->thisDayExpense()[0]->total;
        $data['this_day']['staffSalary'] = $this->staff_model->thisDayStaffSalary()[0]->total;
        $data['this_day']['expense_number'] = $this->finance_model->thisDayExpense()[0]->expense_number;
        $data['this_day']['staffSalary_number'] = $this->staff_model->thisDayStaffSalary()[0]->salary_number;
        $data['this_day']['appointment'] = $this->appointment_model->thisDayAppointment();
        
        $data['this_year']['payment_per_month'] = $this->finance_model->getPaymentPerMonthThisYear();
        $data['this_year']['deposit_per_month'] = $this->finance_model->getDepositPerMonthThisYear();
        $data['this_year']['expense_per_month'] = $this->finance_model->getExpensePerMonthThisYear();
        $data['this_year']['staffSalary_per_month'] = $this->staff_model->getStaffSalaryPerMonthThisYear();

        $this->load->view('dashboard'); // just the header file
        $this->load->view('home', $data);
        $this->load->view('footer', $data);
    }

    

    public function permission() {
        $this->load->view('permission');
    }

    public function license() {   
        $this->load->view('license');
    }

}

/* End of file home.php */
/* Location: ./application/controllers/home.php */
