<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('staff_model');
        $this->load->model('department/department_model');
 
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['staffs'] = $this->staff_model->getStaff();
        $data['departments'] = $this->department_model->getDepartment();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('staff', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new');
        $this->load->view('home/footer'); // just the header file
    }

    public function addNew() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');       
        $email = $this->input->post('email');
        $gender = $this->input->post('gender');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $birth_date = $this->input->post('birth_date');
        $joining_date = $this->input->post('joining_date');
        $department = $this->input->post('department');
        $basic_salary = $this->input->post('basic_salary');
        $status = $this->input->post('status');
        $img_url = $this->input->post('img_url');        

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('email', 'Email', 'trim|min_length[1]|max_length[100]|valid_email|xss_clean');  
        $this->form_validation->set_rules('gender', 'Gender', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[1]|max_length[500]|xss_clean');         
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('birth_date', 'Birth Date', 'trim|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('joining_date', 'Joining Date', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('department', 'Department', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('basic_salary', 'Basic Salary', 'trim|required|min_length[1]|max_length[50]|is_natural_no_zero|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[1]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data['staffs'] = $this->staff_model->getStaff();
            $data['departments'] = $this->department_model->getDepartment();
            $this->load->view('home/dashboard');
            $this->load->view('staff', $data);
            $this->load->view('home/footer'); 
        } 
        else {
            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'img_url' => $img_url,
                    'name' => $name,
                    'email' => $email,
                    'gender' => $gender,
                    'address' => $address,
                    'phone' => $phone,
                    'birth_date' => $birth_date,
                    'joining_date' => $joining_date,
                    'department' => $department,
                    'basic_salary' => $basic_salary,
                    'status' => $status,
                    'added_by' => $this->ion_auth->get_user_id(),
                    'add_date' => time(),                   
                );

            } else {
                $data = array();
                $data = array(
                    'name' => $name,
                    'email' => $email,
                    'gender' => $gender,
                    'address' => $address,
                    'phone' => $phone,
                    'birth_date' => $birth_date,
                    'joining_date' => $joining_date,
                    'department' => $department,
                    'basic_salary' => $basic_salary,
                    'status' => $status,
                    'added_by' => $this->ion_auth->get_user_id(),
                    'add_date' => time(), 
                );
            }

            if (empty($id)) {
                    $this->staff_model->insertStaff($data);
                    $this->session->set_flashdata('feedback', lang('added'));                
            } else {
                unset($data["added_by"]);
                unset($data["add_date"]);
                $data["updated_by"] = $this->ion_auth->get_user_id();
                $data["updated_date"] = time();
                $this->staff_model->updateStaff($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            // Loading View
            redirect('staff');
        }
    }

    function getStaffByJason() {
        $id = $this->input->get('id');
        $data['staff'] = $this->staff_model->getStaffById($id);
        $data['department']=$this->department_model->getDepartmentById($data['staff']->department)->name;
        $data['updated_date'] = date('d-m-Y h:i A', $data['staff']->updated_date);
        echo json_encode($data);
    }

    function deleteStaff() {
        $id = $this->input->get('id');
        $this->staff_model->delete($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('staff');
    }

    public function leave()
    {
        $data['leaves']=$this->staff_model->getLeave();
        $data['staffs'] = $this->staff_model->getWorkingStaff();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('staff/leave', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addLeave() {
        $id = $this->input->post('id');
        $staff = $this->input->post('staff');       
        $leave_type = $this->input->post('leave_type');
        $reason = $this->input->post('reason');
        $leave_from = $this->input->post('leave_from');
        $leave_to = $this->input->post('leave_to');
        $remarks = $this->input->post('remarks');
        $status = $this->input->post('status');      

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('staff', 'Staff', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('leave_type', 'Leave type', 'trim|required|min_length[1]|max_length[100]|xss_clean');  
        $this->form_validation->set_rules('reason', 'Reason', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('leave_from', 'Leave From', 'trim|required|min_length[1]|max_length[500]|xss_clean');         
        $this->form_validation->set_rules('leave_to', 'Leave to', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('remarks', 'Remarks', 'trim|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[1]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data['leaves']=$this->staff_model->getLeave();
            $data['staffs'] = $this->staff_model->getWorkingStaff();
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('staff/leave', $data);
            $this->load->view('home/footer'); // just the header file
        } 
        else {
            $date1 = new DateTime($leave_from);
            $date2 = new DateTime($leave_to);
            $interval = $date1->diff($date2);
            $total_leave=$interval->days+1; //including last day
            $data = array();
            $data = array(
                    'staff' => $staff,
                    'leave_type' => $leave_type,
                    'reason' => $reason,
                    'leave_from' => strtotime($leave_from),
                    'leave_to' => strtotime($leave_to),
                    'total_leave' => $total_leave,
                    'remarks' => $remarks,
                    'status' => $status,
                    'added_by' => $this->ion_auth->get_user_id(),
                    'applied_on' => time(), 
            );

            if (empty($id)) {
                    $this->staff_model->insertLeave($data);
                    $this->session->set_flashdata('feedback', lang('added'));                
            } else {
                unset($data["staff"]);
                unset($data["added_by"]);
                unset($data["applied_on"]);
                $data["updated_by"] = $this->ion_auth->get_user_id();
                $data["updated_date"] = time();
                $this->staff_model->updateLeave($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            // Loading View
            redirect('staff/leave');
        }
    }

    function getLeaveByJason() {
        $id = $this->input->get('id');
        $data['leave'] = $this->staff_model->getLeaveById($id);
        $data['updated_date'] = date('d-m-Y h:i A', $data['leave']->updated_date);
        $data['added_date'] = date('d-m-Y h:i A', $data['leave']->applied_on);
        $data['added_by'] = $this->db->get_where('users', array('id' => $data['leave']->added_by))->row()->username;
        $data['updated_date'] = date('d-m-Y h:i A', $data['leave']->updated_date);
        $data['updated_by'] = $this->db->get_where('users', array('id' => $data['leave']->updated_by))->row()->username;
        $data['leave_from'] = date('d-m-Y', $data['leave']->leave_from);
        $data['leave_to'] = date('d-m-Y', $data['leave']->leave_to);
        echo json_encode($data);
    }

    function getLeaveByStaffByDates() {
        $staff = $this->input->get('staff');
        $for_month = $this->input->get('for_month');
        $for_year = $this->input->get('for_year');
        $d=cal_days_in_month(CAL_GREGORIAN,$for_month,$for_year);
        $d_first=mktime(0,0,0,$for_month,1,$for_year);
        $d_last=mktime(0,0,0,$for_month,$d,$for_year);
        $data['leave'] = $this->staff_model->getLeaveByStaffByDates($staff,$d_first,$d_last);
        echo json_encode($data);
    }

    function deleteLeave() {
        $id = $this->input->get('id');
        $this->staff_model->deleteLeave($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('staff');
    }

    public function addSalary() {
        $id = $this->input->post('id');
        $staff = $this->input->post('staff');       
        $basic_salary_day = $this->input->post('basic_salary_day_hidden');
        $allowance = $this->input->post('allowance');
        $work_day = $this->input->post('work_day');
        $for_month = $this->input->post('for_month');
        $for_year = $this->input->post('for_year');
        $remarks = $this->input->post('remarks');
        $status = $this->input->post('status');  
        $payment_date = $this->input->post('payment_date');      

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('staff', 'Staff', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('basic_salary_day_hidden', 'Basic salary', 'trim|min_length[1]|max_length[100]|xss_clean');  
        $this->form_validation->set_rules('allowance', 'Allowance', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('work_day', 'Working days', 'trim|required|min_length[1]|max_length[500]|xss_clean');         
        $this->form_validation->set_rules('for_month', 'for Month', 'trim|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('for_year', 'for Year', 'trim|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('remarks', 'Remarks', 'trim|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('payment_date', 'Payment Date', 'trim|min_length[1]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data['salarys']=$this->staff_model->getSalary();
            $data['staffs'] = $this->staff_model->getWorkingStaff();
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('staff/salary', $data);
            $this->load->view('home/footer'); // just the header file
        } 
        else {
                $data = array(
                    'staff' => $staff,
                    'basic_salary' => $basic_salary_day*$work_day,
                    'allowance' => $allowance,
                    'total_salary' => $basic_salary_day*$work_day+$allowance,
                    'work_day' => $work_day,
                    'for_month' => date('F', mktime(0, 0, 0, $for_month, 10)).'-'.$for_year,
                    'remarks' => $remarks,
                    'status' => $status,
                    'added_by' => $this->ion_auth->get_user_id(),
                    'added_date' => time(), 
                    'payment_date' => strtotime($payment_date), 
                );

                $data1 = array(
                    'remarks' => $remarks,
                    'status' => $status,
                    'updated_by' => $this->ion_auth->get_user_id(),
                    'updated_date' => time(), 
                    'payment_date' => strtotime($payment_date), 
                );


            if (empty($id)) {
                    $this->staff_model->insertSalary($data);
                    $this->session->set_flashdata('feedback', lang('added'));                
            } else {
                $this->staff_model->updateSalary($id, $data1);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            // Loading View
            redirect('staff/salary');
        }
    }

    public function salary()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['salarys']=$this->staff_model->getSalary();
        $data['staffs'] = $this->staff_model->getWorkingStaff();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('staff/salary', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getSalaryByJason() {
        $id = $this->input->get('id');
        $data['salary'] = $this->staff_model->getSalaryById($id);
        $data['updated_date'] = date('d-m-Y h:i A', $data['salary']->updated_date);
        $data['added_date'] = date('d-m-Y h:i A', $data['salary']->added_date);
        $data['added_by'] = $this->db->get_where('users', array('id' => $data['salary']->added_by))->row()->username;
        $data['updated_date'] = "";
        if (!empty($data['salary']->updated_date))
        $data['updated_date'] = date('d-m-Y h:i A', $data['salary']->updated_date);
        $data['updated_by'] = $this->db->get_where('users', array('id' => $data['salary']->updated_by))->row()->username;
        $data['settings'] = $this->settings_model->getSettings();
        $data['payment_date']=date('d-m-Y', $data['salary']->payment_date);
        echo json_encode($data);
    }

    function deleteSalary() {
        $id = $this->input->get('id');
        $this->staff_model->deleteSalary($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('staff/salary');
    }

    function getSalaryByToday() {
        $hour = 0;
        $today = strtotime($hour . ':00:00'); // 0:00:00 means today
        $today_last = strtotime($hour . ':00:00') + 86399; //11:59:59 means today last time
        $data['salary'] =$this->staff_model->getSalaryByDate($today, $today_last);
        echo json_encode($data);
    }

}

/* End of file staff.php */
/* Location: ./application/modules/staff/controllers/staff.php */
