<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Surgery_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertSurgery($data) {
        $this->db->insert('surgery', $data);
    }

    function getSurgery() {
        $query = $this->db->get('surgery');
        return $query->result();
    }

    function getSurgeryByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('surgery');
        return $query->result();
    }

    function getSurgeryByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('patient_name', $search); //changed by shariat
        $this->db->or_like('patient', $search,'after');
        $this->db->or_like('patient_phone', $search,'after');
        $this->db->or_like('status', $search,'after');
        $this->db->limit($limit, $start);
        $query = $this->db->get('surgery');
        return $query->result();
    }

    function getSurgeryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('surgery');
        return $query->row();
    }

    function updateSurgery($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('surgery', $data);
    }

    function deleteSurgery($id) {
        $this->db->where('id', $id);
        $this->db->delete('surgery');
    }

}
