Payment<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                <?php echo lang('service_charge'); ?>
                <div class="col-md-4 no-print pull-right"> 
                    <a href="finance/addPaymentCategoryView">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs">
                                <i class="fa fa-plus-circle"></i> <?php echo lang('add_service_charge'); ?>
                            </button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table "> 
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('id'); ?>
                                <th><?php echo lang('service'); ?> <?php echo lang('name'); ?></th>
                                <th><?php echo lang('charge'); ?></th>
                                <th><?php echo lang('fixed'); ?> <?php echo lang('doctors_commission'); ?></th>
                                <th><?php echo lang('service'); ?> <?php echo lang('category'); ?></th>
                                
                                <th><?php echo lang('type'); ?></th>
                                <?php if ($this->ion_auth->in_group(array('admin','Accountant', 'Receptionist'))) { ?>
                                    <th class="no-print"><?php echo lang('options'); ?></th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($categories as $category) { ?>
                            <tr class="">
                                <td><?php echo $category->id; ?></td>
                                <td><?php echo $category->category; ?></td>   
                                <td><?php echo $category->c_price; ?> <?php echo $settings->currency; ?></td>
                                <td><?php echo $category->d_commission; ?> <?php echo $settings->currency; ?></td>
                                <td><?php echo ucfirst($category->service_category_name); ?> </td>                                
                                <td><?php echo ucfirst($category->type); ?> </td>
                                <?php if ($this->ion_auth->in_group(array('admin','Accountant', 'Receptionist'))) { ?>
                                    <td class="no-print">
                                        <a class="btn btn-info btn-xs editbutton" title="<?php echo lang('edit'); ?>" href="finance/editPaymentCategory?id=<?php echo $category->id; ?>"><i class="fa fa-edit"> <?php echo lang('edit');?></i></a>
                                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                                        <a class="btn btn-info btn-xs delete_button" title="<?php echo lang('delete'); ?>" href="finance/deletePaymentCategory?id=<?php echo $category->id; ?>&type=<?php echo $category->type; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> <?php echo lang('delete');?></i></a>
                                        <?php } ?>
                                    </td>
                                <?php } ?>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<style>
    .wrapper {
        margin-top: 40px;
    }
</style>

<script src="common/js/codearistos.min.js"></script>
<script>
                                            $(document).ready(function () {
                                                var table = $('#editable-sample').DataTable({
                                                    responsive: true,

                                                    dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                                                            "<'row'<'col-sm-12'tr>>" +
                                                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                                                    buttons: [
                                                        'excelHtml5',
                                                        'pdfHtml5',
                                                        {
                                                            extend: 'print',
                                                            exportOptions: {
                                                                columns: [0, 1, 2, 3, 4],
                                                            }
                                                        },
                                                    ],

                                                    aLengthMenu: [
                                                        [25, 50, 100, -1],
                                                        [25, 50, 100, "All"]
                                                    ],
                                                    iDisplayLength: -1,
                                                    "order": [[4, "asc"]], //changed by shariat

                                                    "language": {
                                                        "lengthMenu": "_MENU_",
                                                        search: "_INPUT_",
                                                        searchPlaceholder: "Search...",
                                                        "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
                                                    },

                                                });

                                                table.buttons().container()
                                                        .appendTo('.custom_buttons');
                                            });
</script>
